<?php 

class Yandex
{
    public $city = 27612;
    public $count = 10;
    public $days_week = array(
                             1 => 'Понедельник', 
                             2 => 'Вторник', 
                             3 => 'Среда', 
                             4 => 'Четверг', 
                             5 => 'Пятница', 
                             6 => 'Суббота', 
                             7 => 'Воскресенье',
                        );
                        
    public $time_day = array(0 => 'утром', 1 => 'днем', 2 => 'вечером', 3 => 'ночью');
    private $tmp_dir = 'sys/tmp/';
    
    protected function get_weather_xml() {
        $data_file = 'http://export.yandex.ru/weather-ng/forecasts/' . $this->city . '.xml';
        $local_file = H. $this->tmp_dir . date("m.d.y.G.") . $this->city .'.xml';
        if (!is_file($local_file)) {
            $file = @file_get_contents($data_file);
            
            if ($file) {
                file_put_contents($local_file, $file);
            }
        }
        
        $xml = simplexml_load_file($local_file);
        
        return $xml;
    }
    
    protected function get_numeric($num) {
        if ($num > 0 ) { 
            return '+' . $num; 
        } else {
            return $num;
        }
    }
    
    public function get_weather_day() {
        
        $counter = 0;
        $xml = $this->get_weather_xml();
        
        $out = array();
        
        $time_fact = date('G');
        
        if ($time_fact >= 0 && $time_fact <= 6) {
            $fact = -1;
        } elseif ($time_fact >= 5 && $time_fact <= 12) {
            $fact = 0;
        } elseif ($time_fact >= 13 && $time_fact <= 18) {
            $fact = 1;
        } elseif ($time_fact >= 19 && $time_fact <= 23) {
            $fact = 2;
        }
        
        $out[0]['day_of_week'] = __('Сегодня');
        $out[1]['day_of_week'] = __('Завтра');
        
        foreach ($xml->day as $day)  {
            
            if ($counter == $this->count) { break; }
            
            if ($counter > 1) {
                $out[$counter]['day_of_week'] = $this->days_week[$day_of_week];
            }
            
            $get_date = explode ("-" , $day['date']) ;
            $day_of_week = date("N", mktime(0, 0, 0, $get_date[1], $get_date[2]+1, $get_date[0]));
            
            $out[$counter]['day'] = $get_date[2];
            $out[$counter]['month'] = $get_date[1];
            $out[$counter]['year'] = $get_date[0];
            $get_date_str = $get_date[2].'.'.$get_date[1].'.'.$get_date[0].' '.$this->days_week[$day_of_week];
            
            for ($i = 0; $i <= 3; $i++) { 
                $get_temp_avg = $this->get_numeric($day->day_part[$i]->{'temperature-data'}->avg);
                $get_temp_from = $this->get_numeric($day->day_part[$i]->{'temperature-data'}->from);
                $get_temp_to = $this->get_numeric($day->day_part[$i]->{'temperature-data'}->to);
                
                $out[$counter]['weather'][$i]['temp_from'] = $get_temp_from;
                $out[$counter]['weather'][$i]['temp_avg'] = $get_temp_avg;
                $out[$counter]['weather'][$i]['temp_to'] = $get_temp_to;
                
                if ($get_temp_from && $get_temp_to) {
                    $out[$counter]['weather'][$i]['temperature'] = $get_temp_from . ' ... ' . $get_temp_to;
                } else {
                    $out[$counter]['weather'][$i]['temperature'] = $get_temp_avg;
                }
                
                $out[$counter]['weather'][$i]['comment'] = $day->day_part[$i]->weather_type;
                $out[$counter]['weather'][$i]['image'] = $day->day_part[$i]->{'image-v3'};
                $out[$counter]['weather'][$i]['time_of_day'] = $this->time_day[$i];
                $out[$counter]['weather'][$i]['name_of_day'] = ($counter <= 1 ? ($counter == 0 ? __('Сегодня') : __('Завтра')) : $get_date_str);
                
                if ($counter == 0 && $i < $fact) {
                    unset($out[$counter]['weather'][$i]);
                } elseif ($counter == 0 && $i == $fact) {
                    $out[$counter]['weather'][$i]['time_of_day'] = '';
                    $out[$counter]['weather'][$i]['name_of_day'] = __('Сейчас');
                    $out[$counter]['weather'][$i]['temperature'] = $get_temp_avg;
                }
            } 
            $counter++;
        }
        
        $array = array();
        $array['country'] = $xml->attributes()->country;
        $array['region'] = $xml->attributes()->part;
        $array['city'] = $xml->attributes()->city;
        $array['day'] = $out;
        
        return $array;
    }
}